package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Secuencias;
import com.ejie.ab04b.model.DatosEnvioPostal;
import com.ejie.ab04b.model.DocumentoAperturas;
import com.ejie.ab04b.model.TareaAperturas;
import com.ejie.ab04b.model.TipoDocumento;
import com.ejie.ab04b.model.TramiteAperturas;
import com.ejie.ab04b.util.DaoUtils;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0465s00DaoImpl generated by UDA, 15-Feb-2017 09:14:46.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class DocumentoAperturasDaoImpl implements DocumentoAperturasDao {

	private static final String QUERY_SELECT = "SELECT t1.ID_DOCUMENTO_065 IDDOCUMENTO065, t1.ID_TRAMITE_APERTURAS_065 IDTRAMITEAPERTURAS065, t1.ORIGEN_065 ORIGEN065, t1.FECHA_DOC_065 FECHADOC065, t1.RUTA_PIF_065 RUTAPIF065, t1.NOMBRE_DOC_065 NOMBREDOC065, t1.OID_DOKUSI_065 OIDDOKUSI065, t1.ID_TIPO_DOC_065 IDTIPODOC065, t1.FORMATO_APORT_065 FORMATOAPORT065, t1.ID_TAREA_CONT_065 IDTAREACONT065, t1.ID_DATOS_ENVIO_POSTAL_065 IDDATOSENVIOPOSTAL065 FROM AB0465S00 t1 ";

	private JdbcTemplate jdbcTemplate;

	/**
	 * Gets the jdbc template.
	 * 
	 *  JdbcTemplate
	 *
	 * @return the jdbc template
	 */
	public JdbcTemplate getJdbcTemplate() {
		return this.jdbcTemplate;
	}

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<DocumentoAperturas> rwMap = new RowMapper<DocumentoAperturas>() {
		public DocumentoAperturas mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			DocumentoAperturas documento = new DocumentoAperturas(
					resultSet.getLong("IDDOCUMENTO065"), new TramiteAperturas(
							resultSet.getLong("IDTRAMITEAPERTURAS065")),
					resultSet.getInt("ORIGEN065"),
					resultSet.getDate("FECHADOC065"),
					resultSet.getString("RUTAPIF065"),
					resultSet.getString("NOMBREDOC065"),
					resultSet.getString("OIDDOKUSI065"), new TipoDocumento(
							resultSet.getLong("IDTIPODOC065")),
					resultSet.getString("FORMATOAPORT065"));

			Long idTareaContinuar = DaoUtils.getInstance().getLongNullable(
					resultSet, "IDTAREACONT065");
			if (idTareaContinuar != null) {
				documento.setTareaAperturasContinuar(new TareaAperturas(
						idTareaContinuar));
			}

			Long idDatosEnvioPostal = DaoUtils.getInstance().getLongNullable(
					resultSet, "IDDATOSENVIOPOSTAL065");
			if (idTareaContinuar != null) {
				documento.setDatosEnvioPostal(new DatosEnvioPostal(
						idDatosEnvioPostal));
			}

			return documento;
		}
	};

	private RowMapper<DocumentoAperturas> rwMapPK = new RowMapper<DocumentoAperturas>() {
		public DocumentoAperturas mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new DocumentoAperturas(resultSet.getLong("IDDOCUMENTO065"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0465s00 table.
	 * 
	 *  ab0465s00
	 *            Ab0465s00
	 *  Ab0465s00
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @return the documento aperturas
	 */
	public DocumentoAperturas add(DocumentoAperturas ab0465s00) {
		String query = "INSERT INTO AB0465S00 (ID_DOCUMENTO_065, ID_TRAMITE_APERTURAS_065, ORIGEN_065, FECHA_DOC_065, RUTA_PIF_065, NOMBRE_DOC_065, OID_DOKUSI_065, ID_TIPO_DOC_065, ID_TAREA_CONT_065, ID_DATOS_ENVIO_POSTAL_065, FORMATO_APORT_065) VALUES (?,?,?,?,?,?,?,?,?,?,?)";

		// Obtenemos la secuencia
		ab0465s00.setIdDocumento065(Secuencias.DOC_APERTURAS
				.getNextLong(jdbcTemplate));

		Long idTareaCont = null;
		if (ab0465s00.getTareaAperturasContinuar() != null) {
			idTareaCont = ab0465s00.getTareaAperturasContinuar()
					.getIdTarea063();
		}

		Long idDatosEnvioPostal = null;
		if (ab0465s00.getDatosEnvioPostal() != null) {
			idTareaCont = ab0465s00.getDatosEnvioPostal()
					.getIdDatosEnvioPostal069();
		}
		Long idTipoDoc = null;
		if (ab0465s00.getTipoDocumento() != null) {
			idTipoDoc = ab0465s00.getTipoDocumento().getIdTipoDoc091();
		}
		this.jdbcTemplate.update(query, ab0465s00.getIdDocumento065(),
				ab0465s00.getTramiteAperturas().getIdTramite062(),
				ab0465s00.getOrigen065(), ab0465s00.getFechaDoc065(),
				ab0465s00.getRutaPif065(), ab0465s00.getNombreDoc065(),
				ab0465s00.getOidDokusi065(), idTipoDoc, idTareaCont,
				idDatosEnvioPostal, ab0465s00.getFormatoAport065());
		return ab0465s00;
	}

	/**
	 * Updates a single row in the Ab0465s00 table.
	 * 
	 *  ab0465s00
	 *            Ab0465s00
	 *  Ab0465s00
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @return the documento aperturas
	 */
	public DocumentoAperturas update(DocumentoAperturas ab0465s00) {
		String query = "UPDATE AB0465S00 SET ID_TRAMITE_APERTURAS_065=?, ORIGEN_065=?, FECHA_DOC_065=?, RUTA_PIF_065=?, NOMBRE_DOC_065=?, OID_DOKUSI_065=?, ID_TIPO_DOC_065=?, ID_TAREA_CONT_065=?, ID_DATOS_ENVIO_POSTAL_065=?, FORMATO_APORT_065=? WHERE ID_DOCUMENTO_065=?";

		Long idTareaCont = null;
		if (ab0465s00.getTareaAperturasContinuar() != null) {
			idTareaCont = ab0465s00.getTareaAperturasContinuar()
					.getIdTarea063();
		}

		Long idDatosEnvioPostal = null;
		if (ab0465s00.getDatosEnvioPostal() != null) {
			idTareaCont = ab0465s00.getDatosEnvioPostal()
					.getIdDatosEnvioPostal069();
		}

		this.jdbcTemplate.update(query, ab0465s00.getTramiteAperturas()
				.getIdTramite062(), ab0465s00.getOrigen065(), ab0465s00
				.getFechaDoc065(), ab0465s00.getRutaPif065(), ab0465s00
				.getNombreDoc065(), ab0465s00.getOidDokusi065(), ab0465s00
				.getTipoDocumento().getIdTipoDoc091(), idTareaCont,
				idDatosEnvioPostal, ab0465s00.getFormatoAport065(), ab0465s00
						.getIdDocumento065());
		return ab0465s00;
	}

	/**
	 * Updates a single row in the Expedientes table.
	 * 
	 *  ab0465s00
	 *            DocumentoAperturas
	 *  DocumentoAperturas
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @return the documento aperturas
	 */
	public DocumentoAperturas updateFilled(DocumentoAperturas ab0465s00) {
		StringBuilder query = new StringBuilder("UPDATE AB0465S00 SET ");

		List<Object> params = new ArrayList<Object>();
		StringBuilder queryFields = new StringBuilder();

		if (ab0465s00 != null) {

			if (ab0465s00.getTareaAperturasContinuar() != null
					&& ab0465s00.getTareaAperturasContinuar().getIdTarea063() != null) {
				queryFields.append(", ID_TAREA_CONT_065 = ? ");
				params.add(ab0465s00.getTareaAperturasContinuar()
						.getIdTarea063());
			}
			if (ab0465s00.getNombreDoc065() != null) {
				queryFields.append(", NOMBRE_DOC_065 = ? ");
				params.add(ab0465s00.getNombreDoc065());
			}
			if (ab0465s00.getOidDokusi065() != null) {
				queryFields.append(", OID_DOKUSI_065 = ? ");
				params.add(ab0465s00.getOidDokusi065());
			}
			if (ab0465s00.getDatosEnvioPostal() != null
					&& ab0465s00.getDatosEnvioPostal()
							.getIdDatosEnvioPostal069() != null) {
				queryFields.append(", ID_DATOS_ENVIO_POSTAL_065 = ? ");
				params.add(ab0465s00.getDatosEnvioPostal()
						.getIdDatosEnvioPostal069());
			}

			if (queryFields.length() > 0) {
				queryFields.deleteCharAt(0);
			}
		}

		query.append(queryFields);
		query.append(" WHERE ID_DOCUMENTO_065 = ?");

		params.add(ab0465s00.getIdDocumento065());

		this.jdbcTemplate.update(query.toString(), params.toArray());
		return ab0465s00;
	}

	/**
	 * Finds a single row in the Ab0465s00 table.
	 * 
	 *  ab0465s00
	 *            Ab0465s00
	 *  Ab0465s00
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @return the documento aperturas
	 */
	@Transactional(readOnly = true)
	public DocumentoAperturas find(DocumentoAperturas ab0465s00) {
		StringBuilder query = new StringBuilder(
				DocumentoAperturasDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_DOCUMENTO_065 = ? ");

		List<DocumentoAperturas> ab0465s00List = this.jdbcTemplate.query(
				query.toString(), this.rwMap, ab0465s00.getIdDocumento065());
		return (DocumentoAperturas) DataAccessUtils.uniqueResult(ab0465s00List);
	}

	/**
	 * Finds a list of rows in the SolicDocumentos table.
	 * 
	 *  solicdocumentos
	 *            SolicDocumentos
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<SolicDocumentos>
	 *
	 * @param solicdocumentos the solicdocumentos
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DocumentoAperturas> buscarPorIdTramiteYMetadatoNombre(
			DocumentoAperturas solicdocumentos,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				DocumentoAperturasDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_TRAMITE_APERTURAS_065 = ? AND UPPER(SUBSTR(t1.NOMBRE_DOC_065, 1, INSTR(t1.NOMBRE_DOC_065, '.', -1) - 1)) = ? ");
		// El metadato object_name nos devuelve el nombre del fichero en
		// minúsculas y sin extensión
		// Buscamos ese nombre en mayúsculas descartando lo que haya en BD a
		// partir del último punto

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DocumentoAperturas>) this.jdbcTemplate.query(query
				.toString(), this.rwMap, solicdocumentos.getTramiteAperturas()
				.getIdTramite062(), solicdocumentos.getNombreDoc065()
				.toUpperCase());
	}

	/**
	 * Finds a single row in the Ab0465s00 table.
	 * 
	 *  oid
	 *            String
	 *  DocumentoAperturas
	 *
	 * @param oid the oid
	 * @return the documento aperturas
	 */
	@Transactional(readOnly = true)
	public DocumentoAperturas findByOid(String oid) {
		StringBuilder query = new StringBuilder(
				DocumentoAperturasDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.OID_DOKUSI_065 = ? ");

		List<DocumentoAperturas> ab0465s00List = this.jdbcTemplate.query(
				query.toString(), this.rwMap, oid);
		return (DocumentoAperturas) DataAccessUtils.uniqueResult(ab0465s00List);
	}
	
	/**
	 * Finds a single row in the Ab0465s00 table.
	 * 
	 *  ab0465s00
	 *            DocumentoAperturas
	 *  DocumentoAperturas
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @return the documento aperturas
	 */
	@Transactional(readOnly = true)
	public DocumentoAperturas findByTramite(DocumentoAperturas ab0465s00) {
		StringBuilder query = new StringBuilder(
				DocumentoAperturasDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0465s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		List<DocumentoAperturas> ab0465s00List = this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
		
		return (DocumentoAperturas) DataAccessUtils.uniqueResult(ab0465s00List);
	}

	/**
	 * Removes a single row in the Ab0465s00 table.
	 * 
	 *  ab0465s00            Ab0465s00
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 */
	public void remove(DocumentoAperturas ab0465s00) {
		String query = "DELETE FROM AB0465S00 WHERE ID_DOCUMENTO_065=?";
		this.jdbcTemplate.update(query, ab0465s00.getIdDocumento065());
	}

	/**
	 * Updates a single row in the Solicitudes table.
	 * 
	 *  doc
	 *            SolicDocumentos
	 *  SolicDocumentos
	 *
	 * @param doc the doc
	 * @return the documento aperturas
	 */
	public DocumentoAperturas updateOidDokusi(DocumentoAperturas doc) {
		StringBuilder query = new StringBuilder("UPDATE AB0465S00 SET ");

		List<Object> params = new ArrayList<Object>();
		StringBuilder queryFields = new StringBuilder();

		if (doc != null) {
			if (doc.getOidDokusi065() != null) {
				queryFields.append(", OID_DOKUSI_065 = ? ");
				params.add(doc.getOidDokusi065());
			}

			if (queryFields.length() > 0) {
				queryFields.deleteCharAt(0);
			}
		}

		query.append(queryFields);
		query.append(" WHERE ID_DOCUMENTO_065 = ?");

		params.add(doc.getIdDocumento065());

		this.jdbcTemplate.update(query.toString(), params.toArray());
		return doc;
	}

	/**
	 * Finds a list of rows in the Ab0465s00 table.
	 * 
	 *  ab0465s00
	 *            Ab0465s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0465s00>
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DocumentoAperturas> findAll(DocumentoAperturas ab0465s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				DocumentoAperturasDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0465s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DocumentoAperturas>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab0465s00 table using like.
	 * 
	 *  ab0465s00
	 *            Ab0465s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0465s00>
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DocumentoAperturas> findAllLike(DocumentoAperturas ab0465s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				DocumentoAperturasDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0465s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DocumentoAperturas>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0465s00 table.
	 * 
	 *  ab0465s00
	 *            Ab0465s00
	 *  Long
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(DocumentoAperturas ab0465s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0465S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0465s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab0465s00 table using like.
	 * 
	 *  ab0465s00
	 *            Ab0465s00
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(DocumentoAperturas ab0465s00,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0465S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0465s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab0465s00 selected for rup_table.
	 * 
	 *  ab0465s00            Ab0465s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0465s00>>
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<DocumentoAperturas>> reorderSelection(
			DocumentoAperturas ab0465s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				DocumentoAperturasDaoImpl.QUERY_SELECT);
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0465s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, DocumentoAperturas.class,
				filterParamList, "ID_DOCUMENTO_065");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<DocumentoAperturas>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            Ab0465s00
	 *  searchParams            Ab0465s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0465s00>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<DocumentoAperturas>> search(
			DocumentoAperturas filterParams, DocumentoAperturas searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				DocumentoAperturasDaoImpl.QUERY_SELECT);
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings(value = "unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, DocumentoAperturas.class,
				filterParamList, searchSQL, searchParamList, from_alias,
				"ID_DOCUMENTO_065");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<DocumentoAperturas>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0465s00 entity.
	 * 
	 *  ab0465s00            Ab0465s00 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(DocumentoAperturas ab0465s00) {

		StringBuilder where = new StringBuilder(
				DocumentoAperturasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0465s00 != null && ab0465s00.getIdDocumento065() != null) {
			where.append(" AND t1.ID_DOCUMENTO_065 = ?");
			params.add(ab0465s00.getIdDocumento065());
		}
		if (ab0465s00 != null && ab0465s00.getTramiteAperturas() != null
				&& ab0465s00.getTramiteAperturas().getIdTramite062() != null) {
			where.append(" AND t1.ID_TRAMITE_APERTURAS_065 = ?");
			params.add(ab0465s00.getTramiteAperturas().getIdTramite062());
		}
		if (ab0465s00 != null && ab0465s00.getOrigen065() != null) {
			where.append(" AND t1.ORIGEN_065 = ?");
			params.add(ab0465s00.getOrigen065());
		}
		if (ab0465s00 != null && ab0465s00.getFechaDoc065() != null) {
			where.append(" AND t1.FECHA_DOC_065 = ?");
			params.add(ab0465s00.getFechaDoc065());
		}
		if (ab0465s00 != null && ab0465s00.getRutaPif065() != null) {
			where.append(" AND t1.RUTA_PIF_065 = ?");
			params.add(ab0465s00.getRutaPif065());
		}
		if (ab0465s00 != null && ab0465s00.getNombreDoc065() != null) {
			where.append(" AND t1.NOMBRE_DOC_065 = ?");
			params.add(ab0465s00.getNombreDoc065());
		}
		if (ab0465s00 != null && ab0465s00.getOidDokusi065() != null) {
			where.append(" AND t1.OID_DOKUSI_065 = ?");
			params.add(ab0465s00.getOidDokusi065());
		}
		if (ab0465s00 != null && ab0465s00.getTipoDocumento() != null
				&& ab0465s00.getTipoDocumento().getIdTipoDoc091() != null) {
			where.append(" AND t1.ID_TIPO_DOC_065 = ?");
			params.add(ab0465s00.getTipoDocumento().getIdTipoDoc091());
		}
		if (ab0465s00 != null && ab0465s00.getFormatoAport065() != null) {
			where.append(" AND t1.FORMATO_APORT_065 = ?");
			params.add(ab0465s00.getFormatoAport065());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0465s00 entity.
	 * 
	 *  ab0465s00            Ab0465s00 Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(DocumentoAperturas ab0465s00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				DocumentoAperturasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0465s00 != null && ab0465s00.getIdDocumento065() != null) {
			where.append(" AND t1.ID_DOCUMENTO_065 = ?");
			params.add(ab0465s00.getIdDocumento065());
		}
		if (ab0465s00 != null && ab0465s00.getTramiteAperturas() != null
				&& ab0465s00.getTramiteAperturas().getIdTramite062() != null) {
			where.append(" AND t1.ID_TRAMITE_APERTURAS_065 = ?");
			params.add(ab0465s00.getTramiteAperturas().getIdTramite062());
		}
		if (ab0465s00 != null && ab0465s00.getOrigen065() != null) {
			where.append(" AND t1.ORIGEN_065 = ?");
			params.add(ab0465s00.getOrigen065());
		}
		if (ab0465s00 != null && ab0465s00.getFechaDoc065() != null) {
			where.append(" AND t1.FECHA_DOC_065 = ?");
			params.add(ab0465s00.getFechaDoc065());
		}
		if (ab0465s00 != null && ab0465s00.getRutaPif065() != null) {
			where.append(" AND UPPER(t1.RUTA_PIF_065) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0465s00.getRutaPif065().toUpperCase() + "%");
			} else {
				params.add("%" + ab0465s00.getRutaPif065().toUpperCase() + "%");
			}
			where.append(" AND t1.RUTA_PIF_065 IS NOT NULL");
		}
		if (ab0465s00 != null && ab0465s00.getNombreDoc065() != null) {
			where.append(" AND UPPER(t1.NOMBRE_DOC_065) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0465s00.getNombreDoc065().toUpperCase() + "%");
			} else {
				params.add("%" + ab0465s00.getNombreDoc065().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_DOC_065 IS NOT NULL");
		}
		if (ab0465s00 != null && ab0465s00.getOidDokusi065() != null) {
			where.append(" AND UPPER(t1.OID_DOKUSI_065) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0465s00.getOidDokusi065().toUpperCase() + "%");
			} else {
				params.add("%" + ab0465s00.getOidDokusi065().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.OID_DOKUSI_065 IS NOT NULL");
		}
		if (ab0465s00 != null && ab0465s00.getTipoDocumento() != null
				&& ab0465s00.getTipoDocumento().getIdTipoDoc091() != null) {
			where.append(" AND t1.ID_TIPO_DOC_065 = ?");
			params.add(ab0465s00.getTipoDocumento().getIdTipoDoc091());
		}
		if (ab0465s00 != null && ab0465s00.getFormatoAport065() != null) {
			where.append(" AND t1.FORMATO_APORT_065 = ?");
			params.add(ab0465s00.getFormatoAport065());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
